local t = Def.ActorFrame{
	-- Main text area of the "INFO" pane.
	Def.Quad{
		OnCommand=function(self)
			self:horizalign(left):vertalign(bottom):xy(0,_screen.h):zoomto(_screen.w,84):diffuse(LocalBlueColor(0))
		end
	},
	-- lights!
	LoadActor(THEME:GetPathG("_common", "smallneon")) .. {
		OnCommand=function(self)
			self:xy(_screen.cx,_screen.h-84+10):vertalign(bottom):zoomto(_screen.w*1.3,20):blend(Blend.Add)
		end
	},
	-- Header of the "INFO" pane, for both players.
	LoadActor(THEME:GetPathG("", "_info")) .. {
		InitCommand=cmd(horizalign,left;vertalign,top;xy,-10,_screen.h-112;diffuse,PlayerColor(PLAYER_1))
	},
	LoadActor(THEME:GetPathG("", "_info")) .. {
		InitCommand=cmd(horizalign,left;vertalign,top;xy,_screen.w+10,_screen.h-112;zoomx,-1;diffuse,PlayerColor(PLAYER_2))
	},
	-- Text on the "INFO" pane; again, for both players.
	Def.BitmapText{
		Font="Common Normal",
		Text=string.upper(THEME:GetString("Misc", "Info")),
		InitCommand=function(self)
			self:horizalign(left):vertalign(top):xy(22,(_screen.h-(_screen.h/4.5))+5):zoom(0.6):strokecolor(Color.Black):diffuse(ColorBlend(Color.White, PlayerColor(PLAYER_1)))
		end,
	},
	Def.BitmapText{
		Font="Common Normal",
		Text=string.upper(THEME:GetString("Misc", "Info")),
		InitCommand=function(self)
			self:horizalign(right):vertalign(top):xy(_screen.w-22,(_screen.h-(_screen.h/4.5))+5):zoom(0.6):strokecolor(Color.Black):diffuse(ColorBlend(Color.White, PlayerColor(PLAYER_2)))
		end,
	},
}

t[#t+1] = LoadFallbackB()

return t